/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.client.screen.CheckBox;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.crafting.RecipeType;
import com.mrcrayfish.vehicle.crafting.VehicleRecipe;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.inventory.container.WorkstationContainer;
import com.mrcrayfish.vehicle.item.EngineItem;
import com.mrcrayfish.vehicle.item.WheelItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageCraftVehicle;
import com.mrcrayfish.vehicle.tileentity.WorkstationTileEntity;
import com.mrcrayfish.vehicle.util.CommonUtils;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WorkstationScreen
extends ContainerScreen<WorkstationContainer> {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/workstation.png");
    private List<EntityType<?>> vehicleTypes;
    private List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private static int currentVehicle = 0;
    private static int prevCurrentVehicle = 0;
    private static boolean showRemaining = false;
    private VehicleEntity[] cachedVehicle;
    private PlayerInventory playerInventory;
    private WorkstationTileEntity workstation;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private boolean validEngine;
    private boolean transitioning;
    private int vehicleScale = 30;
    private int prevVehicleScale = 30;

    public WorkstationScreen(WorkstationContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workstation = container.getTileEntity();
        this.field_146999_f = 289;
        this.field_147000_g = 202;
        this.materials = new ArrayList<MaterialItem>();
        this.vehicleTypes = this.getVehicleTypes(playerInventory.field_70458_d.field_70170_p);
        this.vehicleTypes.sort(Comparator.comparing(type -> type.getRegistryName().func_110623_a()));
        this.cachedVehicle = new VehicleEntity[this.vehicleTypes.size()];
    }

    private List<EntityType<?>> getVehicleTypes(World world) {
        return world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == RecipeType.CRAFTING).map(recipe -> (VehicleRecipe)recipe).map(VehicleRecipe::getVehicle).collect(Collectors.toList());
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_230480_a_((Widget)new Button(startX, startY, 15, 20, (ITextComponent)new StringTextComponent("<"), button -> {
            this.loadVehicle(Math.floorMod(currentVehicle - 1, this.vehicleTypes.size()));
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }));
        this.func_230480_a_((Widget)new Button(startX + 161, startY, 15, 20, (ITextComponent)new StringTextComponent(">"), button -> {
            this.loadVehicle(Math.floorMod(currentVehicle + 1, this.vehicleTypes.size()));
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }));
        this.btnCraft = (Button)this.func_230480_a_((Widget)new Button(startX + 186, startY + 6, 97, 20, (ITextComponent)new StringTextComponent("Craft"), button -> {
            ResourceLocation registryName = this.cachedVehicle[currentVehicle].func_200600_R().getRegistryName();
            Objects.requireNonNull(registryName, "Vehicle registry name must not be null!");
            PacketHandler.instance.sendToServer((Object)new MessageCraftVehicle(registryName.toString(), this.workstation.func_174877_v()));
        }));
        this.btnCraft.field_230693_o_ = false;
        this.checkBoxMaterials = (CheckBox)this.func_230480_a_(new CheckBox(startX + 186, startY + 51, (ITextComponent)new StringTextComponent("Show Remaining")));
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadVehicle(currentVehicle);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.validEngine = true;
        for (MaterialItem materialItem : this.materials) {
            materialItem.update();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        if (this.cachedVehicle[currentVehicle] instanceof PoweredVehicleEntity) {
            PoweredVehicleEntity poweredVehicleEntity = (PoweredVehicleEntity)this.cachedVehicle[currentVehicle];
            if (poweredVehicleEntity.getEngineType() != EngineType.NONE) {
                ItemStack engine = this.workstation.func_70301_a(1);
                if (!engine.func_190926_b() && engine.func_77973_b() instanceof EngineItem) {
                    EngineItem engineItem = (EngineItem)engine.func_77973_b();
                    EngineType engineType = engineItem.getEngineType();
                    if (poweredVehicleEntity.getEngineType() != engineType) {
                        canCraft = false;
                        this.validEngine = false;
                        poweredVehicleEntity.setEngine(false);
                    } else {
                        poweredVehicleEntity.setEngineTier(engineItem.getEngineTier());
                        poweredVehicleEntity.setEngine(true);
                        poweredVehicleEntity.func_184206_a(PoweredVehicleEntity.ENGINE_TIER);
                    }
                } else {
                    canCraft = false;
                    this.validEngine = false;
                    poweredVehicleEntity.setEngine(false);
                }
            }
            if (poweredVehicleEntity.canChangeWheels()) {
                ItemStack wheels = this.workstation.func_70301_a(2);
                if (!wheels.func_190926_b() && wheels.func_77973_b() instanceof WheelItem) {
                    CompoundNBT tagCompound;
                    if (wheels.func_77978_p() != null && (tagCompound = wheels.func_77978_p()).func_150297_b("Color", 3)) {
                        poweredVehicleEntity.setWheelColor(tagCompound.func_74762_e("Color"));
                    }
                    WheelItem wheelItem = (WheelItem)wheels.func_77973_b();
                    poweredVehicleEntity.setWheelType(wheelItem.getWheelType());
                    poweredVehicleEntity.setWheels(true);
                    poweredVehicleEntity.func_184206_a(PoweredVehicleEntity.WHEEL_COLOR);
                } else {
                    poweredVehicleEntity.setWheels(false);
                    canCraft = false;
                }
            }
        }
        this.btnCraft.field_230693_o_ = canCraft;
        this.prevVehicleScale = this.vehicleScale;
        if (this.transitioning) {
            if (this.vehicleScale > 0) {
                this.vehicleScale = Math.max(0, this.vehicleScale - 6);
            } else {
                this.transitioning = false;
            }
        } else if (this.vehicleScale < 30) {
            this.vehicleScale = Math.min(30, this.vehicleScale + 6);
        }
        if (this.cachedVehicle[currentVehicle].canBeColored()) {
            if (!this.workstation.func_70301_a(0).func_190926_b()) {
                ItemStack itemStack = this.workstation.func_70301_a(0);
                if (itemStack.func_77973_b() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)itemStack.func_77973_b();
                    this.cachedVehicle[currentVehicle].setColor(dyeItem.func_195962_g().getColorValue());
                } else {
                    this.cachedVehicle[currentVehicle].setColor(VehicleEntity.DYE_TO_COLOR[0]);
                }
            } else {
                this.cachedVehicle[currentVehicle].setColor(VehicleEntity.DYE_TO_COLOR[0]);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.func_231044_a_(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        return result;
    }

    private void loadVehicle(int index) {
        prevCurrentVehicle = currentVehicle;
        if (this.cachedVehicle[index] == null) {
            VehicleEntity vehicle = (VehicleEntity)this.vehicleTypes.get(index).func_200721_a((World)this.field_230706_i_.field_71441_e);
            List entryList = vehicle.func_184212_Q().func_187231_c();
            if (entryList != null) {
                entryList.forEach(dataEntry -> vehicle.func_184206_a(dataEntry.func_187205_a()));
            }
            if (vehicle instanceof PoweredVehicleEntity) {
                ((PoweredVehicleEntity)vehicle).setEngine(false);
                ((PoweredVehicleEntity)vehicle).setWheels(false);
            }
            this.cachedVehicle[index] = vehicle;
        }
        this.materials.clear();
        VehicleRecipe recipe = VehicleRecipes.getRecipe(this.cachedVehicle[index].func_200600_R(), (World)this.field_230706_i_.field_71441_e);
        if (recipe != null) {
            for (int i = 0; i < recipe.getMaterials().size(); ++i) {
                MaterialItem item = new MaterialItem(((ItemStack)recipe.getMaterials().get(i)).func_77946_l());
                item.update();
                this.materials.add(item);
            }
        }
        currentVehicle = index;
        if (((Boolean)Config.CLIENT.workstationAnimation.get()).booleanValue() && prevCurrentVehicle != currentVehicle) {
            this.transitioning = true;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        for (int i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 186;
            int itemY = startY + i * 19 + 6 + 57;
            if (!CommonUtils.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)).getStack().func_190926_b()) continue;
            this.func_230457_a_(matrixStack, materialItem.getStack(), mouseX, mouseY);
        }
        VehicleEntity vehicle = this.cachedVehicle[currentVehicle];
        if (vehicle.canBeColored()) {
            this.drawSlotTooltip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("vehicle.tooltip.optional"), new TranslationTextComponent("vehicle.tooltip.paint_color")}), startX, startY, 186, 29, mouseX, mouseY, 0);
        } else {
            this.drawSlotTooltip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("vehicle.tooltip.paint_color"), new TranslationTextComponent("vehicle.tooltip.not_applicable")}), startX, startY, 186, 29, mouseX, mouseY, 0);
        }
        if (vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).getEngineType() != EngineType.NONE) {
            String engineName = ((PoweredVehicleEntity)vehicle).getEngineType().getEngineName();
            this.drawSlotTooltip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("vehicle.tooltip.required"), new TranslationTextComponent(engineName)}), startX, startY, 206, 29, mouseX, mouseY, 1);
        } else {
            this.drawSlotTooltip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("vehicle.tooltip.engine"), new TranslationTextComponent("vehicle.tooltip.not_applicable")}), startX, startY, 206, 29, mouseX, mouseY, 1);
        }
        if (vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).canChangeWheels()) {
            this.drawSlotTooltip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("vehicle.tooltip.required"), new TranslationTextComponent("vehicle.tooltip.wheels")}), startX, startY, 226, 29, mouseX, mouseY, 2);
        } else {
            this.drawSlotTooltip(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("vehicle.tooltip.wheels"), new TranslationTextComponent("vehicle.tooltip.not_applicable")}), startX, startY, 226, 29, mouseX, mouseY, 2);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        partialTicks = this.field_230706_i_.func_184121_ak();
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        RenderSystem.enableBlend();
        this.field_230706_i_.func_110434_K().func_110577_a(GUI);
        this.func_238474_b_(matrixStack, startX, startY + 80, 0, 134, 176, 122);
        this.func_238474_b_(matrixStack, startX + 180, startY, 176, 54, 6, 208);
        this.func_238474_b_(matrixStack, startX + 186, startY, 182, 54, 57, 208);
        this.func_238474_b_(matrixStack, startX + 186 + 57, startY, 220, 54, 23, 208);
        this.func_238474_b_(matrixStack, startX + 186 + 57 + 23, startY, 220, 54, 3, 208);
        this.func_238474_b_(matrixStack, startX + 186 + 57 + 23 + 3, startY, 236, 54, 20, 208);
        this.drawSlot(matrixStack, startX, startY, 186, 29, 80, 0, 0, false, this.cachedVehicle[currentVehicle].canBeColored());
        boolean needsEngine = this.cachedVehicle[currentVehicle] instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)this.cachedVehicle[currentVehicle]).getEngineType() != EngineType.NONE;
        this.drawSlot(matrixStack, startX, startY, 206, 29, 80, 16, 1, !this.validEngine, needsEngine);
        boolean needsWheels = this.cachedVehicle[currentVehicle] instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)this.cachedVehicle[currentVehicle]).canChangeWheels();
        this.drawSlot(matrixStack, startX, startY, 226, 29, 80, 32, 2, needsWheels && this.workstation.func_70301_a(2).func_190926_b(), needsWheels);
        WorkstationScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.cachedVehicle[currentVehicle].func_200200_C_().getString(), (int)(startX + 88), (int)(startY + 6), (int)Color.WHITE.getRGB());
        this.filteredMaterials = this.getMaterials();
        for (int i = 0; i < this.filteredMaterials.size(); ++i) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(GUI);
            MaterialItem materialItem = this.filteredMaterials.get(i);
            ItemStack stack = materialItem.stack;
            if (stack.func_190926_b()) {
                RenderHelper.func_74518_a();
                this.func_238474_b_(matrixStack, startX + 186, startY + i * 19 + 6 + 57, 0, 19, 80, 19);
                continue;
            }
            RenderHelper.func_74518_a();
            if (materialItem.isEnabled()) {
                this.func_238474_b_(matrixStack, startX + 186, startY + i * 19 + 6 + 57, 0, 0, 80, 19);
            } else {
                this.func_238474_b_(matrixStack, startX + 186, startY + i * 19 + 6 + 57, 0, 38, 80, 19);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = stack.func_200301_q().getString();
            if (this.field_230712_o_.func_78256_a(name) > 55) {
                name = this.field_230712_o_.func_238412_a_(stack.func_200301_q().getString(), 50).trim() + "...";
            }
            this.field_230712_o_.func_238421_b_(matrixStack, name, (float)(startX + 186 + 22), (float)(startY + i * 19 + 6 + 6 + 57), Color.WHITE.getRGB());
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 57);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((PlayerEntity)this.field_230706_i_.field_71439_g, stack);
                stack = stack.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() - count);
            }
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.field_230712_o_, stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 57, null);
        }
        this.drawVehicle(startX + 88, startY + 90, partialTicks);
    }

    private void drawVehicle(int x, int y, float partialTicks) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        float scale = (float)this.prevVehicleScale + (float)(this.vehicleScale - this.prevVehicleScale) * partialTicks;
        matrixStack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Axis.POSITIVE_X.func_229187_a_(-5.0f);
        Quaternion quaternion1 = Axis.POSITIVE_Y.func_229187_a_(-((float)this.field_230706_i_.field_71439_g.field_70173_aa + partialTicks));
        quaternion.func_195890_a(quaternion1);
        matrixStack.func_227863_a_(quaternion);
        int vehicleIndex = this.transitioning ? prevCurrentVehicle : currentVehicle;
        VehicleProperties properties = VehicleProperties.getProperties(this.cachedVehicle[vehicleIndex].func_200600_R());
        PartPosition position = PartPosition.DEFAULT;
        if (properties != null) {
            position = properties.getDisplayPosition();
        }
        matrixStack.func_227862_a_((float)position.getScale(), (float)position.getScale(), (float)position.getScale());
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_((float)position.getRotX()));
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)position.getRotY()));
        matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_((float)position.getRotZ()));
        matrixStack.func_227861_a_(position.getX(), position.getY(), position.getZ());
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.func_178633_a(false);
        renderManager.func_229089_a_(quaternion);
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> renderManager.func_229084_a_((Entity)this.cachedVehicle[vehicleIndex], 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0));
        renderTypeBuffer.func_228461_a_();
        renderManager.func_178633_a(true);
        matrixStack.func_227865_b_();
        RenderSystem.popMatrix();
    }

    private void drawSlot(MatrixStack matrixStack, int startX, int startY, int x, int y, int iconX, int iconY, int slot, boolean required, boolean applicable) {
        int textureOffset = required ? 18 : 0;
        this.func_238474_b_(matrixStack, startX + x, startY + y, 128 + textureOffset, 0, 18, 18);
        if (this.workstation.func_70301_a(slot).func_190926_b()) {
            if (applicable) {
                this.func_238474_b_(matrixStack, startX + x + 1, startY + y + 1, iconX + (required ? 16 : 0), iconY, 16, 16);
            } else {
                this.func_238474_b_(matrixStack, startX + x + 1, startY + y + 1, iconX + (required ? 16 : 0), 48, 16, 16);
            }
        }
    }

    private void drawSlotTooltip(MatrixStack matrixStack, List<ITextComponent> text, int startX, int startY, int x, int y, int mouseX, int mouseY, int slot) {
        if (this.workstation.func_70301_a(slot).func_190926_b() && CommonUtils.isMouseWithin(mouseX, mouseY, startX + x, startY + y, 18, 18)) {
            this.func_238654_b_(matrixStack, Lists.transform(text, ITextComponent::func_241878_f), mouseX, mouseY);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.func_191197_a((int)7, (Object)new MaterialItem(ItemStack.field_190927_a));
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : !((MaterialItem)materialItem).stack.func_190926_b()).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, filteredMaterials.get(i));
        }
        return materials;
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.playerInventory.func_145748_c_().getString(), 8.0f, 109.0f, 0x404040);
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private boolean enabled = false;
        private ItemStack stack = ItemStack.field_190927_a;

        public MaterialItem() {
        }

        public MaterialItem(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void update() {
            if (!this.stack.func_190926_b()) {
                this.enabled = InventoryUtil.hasItemStack((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.stack);
            }
        }

        public boolean isEnabled() {
            return this.stack.func_190926_b() || this.enabled;
        }
    }
}

